/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.fabricators_of_create.porting_lib.event.client.OverlayRenderCallback;
import io.github.fabricators_of_create.porting_lib.models.geometry.IGeometryLoader;
import io.github.fabricators_of_create.porting_lib.models.geometry.RegisterGeometryLoadersCallback;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1041;
import net.minecraft.class_1306;
import net.minecraft.class_1934;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3264;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4061;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5616;
import net.minecraft.class_837;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.client.ExtraHeartRenderHandler;
import slimeknights.mantle.client.ResourceColorManager;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.repository.FileRepository;
import slimeknights.mantle.client.model.FallbackModelLoader;
import slimeknights.mantle.client.model.NBTKeyModel;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.connected.ConnectedModel;
import slimeknights.mantle.client.model.fluid.FluidTextureModel;
import slimeknights.mantle.client.model.fluid.FluidsModel;
import slimeknights.mantle.client.model.inventory.InventoryModel;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.MantleItemLayerModel;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.render.MantleShaders;
import slimeknights.mantle.fluid.tooltip.FluidTooltipHandler;
import slimeknights.mantle.network.MantleNetwork;
import slimeknights.mantle.registration.MantleRegistrations;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.util.OffhandCooldownTracker;

public class ClientEvents
implements ClientModInitializer {
    private static final Function<OffhandCooldownTracker, Float> COOLDOWN_TRACKER = OffhandCooldownTracker::getCooldown;

    static void registerEntityRenderers() {
        class_5616.method_32144(MantleRegistrations.SIGN, class_837::new);
    }

    static void registerListeners() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)ModelHelper.LISTENER);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new BookLoader());
        ResourceColorManager.init();
        FluidTooltipHandler.init();
    }

    public void onInitializeClient() {
        RegistrationHelper.forEachWoodType(woodType -> {
            class_2960 location = new class_2960(woodType.comp_1299());
            class_4722.field_21712.put(woodType, new class_4730(class_4722.field_21708, new class_2960(location.method_12836(), "entity/signs/" + location.method_12832())));
        });
        BookLoader.registerBook(Mantle.getResource("test"), new FileRepository(Mantle.getResource("books/test")));
        ClientEvents.registerEntityRenderers();
        ClientEvents.registerListeners();
        CoreShaderRegistrationCallback.EVENT.register(MantleShaders::registerShaders);
        RegisterGeometryLoadersCallback.EVENT.register(ClientEvents::registerModelLoaders);
        ClientEvents.commonSetup();
        MantleNetwork.INSTANCE.network.initClientListener();
    }

    static void registerModelLoaders(Map<class_2960, IGeometryLoader<?>> loaders) {
        loaders.put(Mantle.getResource("connected"), ConnectedModel.Loader.INSTANCE);
        loaders.put(Mantle.getResource("item_layer"), MantleItemLayerModel.LOADER);
        loaders.put(Mantle.getResource("colored_block"), ColoredBlockModel.LOADER);
        loaders.put(Mantle.getResource("fallback"), FallbackModelLoader.INSTANCE);
        loaders.put(Mantle.getResource("nbt_key"), NBTKeyModel.LOADER);
        loaders.put(Mantle.getResource("retextured"), RetexturedModel.Loader.INSTANCE);
        loaders.put(Mantle.getResource("fluid_texture"), FluidTextureModel.LOADER);
        loaders.put(Mantle.getResource("inventory"), InventoryModel.Loader.INSTANCE);
        loaders.put(Mantle.getResource("fluids"), FluidsModel.Loader.INSTANCE);
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)FluidTextureModel.LOADER);
    }

    static void commonSetup() {
        OverlayRenderCallback.EVENT.register(new ExtraHeartRenderHandler()::renderHealthbar);
        OverlayRenderCallback.EVENT.register(ClientEvents::renderOffhandAttackIndicator);
    }

    private static boolean renderOffhandAttackIndicator(class_332 guiGraphics, float partialTicks, class_1041 window, OverlayRenderCallback.Types overlay) {
        class_310 minecraft = class_310.method_1551();
        class_315 settings = minecraft.field_1690;
        if (minecraft.field_1724 == null || minecraft.field_1761 == null || minecraft.field_1761.method_2920() == class_1934.field_9219 || settings.method_42565().method_41753() == class_4061.field_18151) {
            return false;
        }
        if (overlay != OverlayRenderCallback.Types.CROSSHAIRS) {
            return false;
        }
        float cooldown = OffhandCooldownTracker.CAPABILITY.maybeGet((Object)minecraft.field_1724).filter(OffhandCooldownTracker::isEnabled).map(COOLDOWN_TRACKER).orElse(Float.valueOf(1.0f)).floatValue();
        if (cooldown >= 1.0f) {
            return false;
        }
        switch ((class_4061)settings.method_42565().method_41753()) {
            case field_18152: {
                if (overlay != OverlayRenderCallback.Types.CROSSHAIRS || !minecraft.field_1690.method_31044().method_31034() || settings.field_1866 && !settings.field_1842 && !minecraft.field_1724.method_7302() && !((Boolean)settings.method_42442().method_41753()).booleanValue()) break;
                RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.ONE_MINUS_DST_COLOR, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_COLOR, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
                int scaledHeight = minecraft.method_22683().method_4502();
                int y = scaledHeight / 2 - 14 + 2 * (scaledHeight % 2);
                int x = minecraft.method_22683().method_4486() / 2 - 8;
                int width = (int)(cooldown * 17.0f);
                guiGraphics.method_25302(class_329.field_44654, x, y, 36, 94, 16, 4);
                guiGraphics.method_25302(class_329.field_44654, x, y, 52, 94, width, 4);
                break;
            }
            case field_18153: {
                if (minecraft.field_1719 != minecraft.field_1724) break;
                int centerWidth = minecraft.method_22683().method_4486() / 2;
                int y = minecraft.method_22683().method_4502() - 20;
                int x = minecraft.field_1724.method_6068() == class_1306.field_6183 ? centerWidth - 91 - 22 - 32 : centerWidth + 91 + 6 + 32;
                int l1 = (int)(cooldown * 19.0f);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.method_25302(class_329.field_44654, x, y, 0, 94, 18, 18);
                guiGraphics.method_25302(class_329.field_44654, x, y + 18 - l1, 18, 112 - l1, 18, l1);
            }
        }
        return false;
    }
}

